/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class GasProcessesAP
extends AP6
implements CaretListener {
    static final String[][] text = new String[][]{{"de", "Zustands\u00e4nderungen eines idealen Gases", "Isobare Zustands\u00e4nderung", "Isochore Zustands\u00e4nderung", "Isotherme Zustands\u00e4nderung", "Anfangszustand:", "Endzustand:", "Druck", "Volumen", "Temperatur", "Anfangszustand", "Start", "Arbeit", "W\u00e4rme", "Die innere Energie des Gases", "vergr\u00f6\u00dfert sich.", "Die innere Energie des Gases", "bleibt unver\u00e4ndert.", "Die innere Energie des Gases", "verkleinert sich.", "Druck zu klein!", "Druck zu gro\u00df!", "Volumen zu klein!", "Volumen zu gro\u00df!", "Temperatur zu klein!", "Temperatur zu gro\u00df!", ""}, {"en", "Special Processes of an Ideal Gas", "Isobaric process", "Isochoric process", "Isothermal process", "Initial state:", "Final state:", "Pressure", "Volume", "Temperature", "Initial state", "Start", "Work", "Heat", "The internal energy of the gas", "increases.", "The internal energy of the gas", "is constant.", "The internal energy of the gas", "decreases.", "Pressure too small!", "Pressure too big!", "Volume too small!", "Volume too big!", "Temperature too small!", "Temperature too big!", ""}};
    private int[] gaps = new int[]{5, 0, 0, 5, 5, 2, 2, 5, 5, 2, 2, 5, 5, 5, 2, 5};
    final int width = 700;
    final int height = 440;
    final int width0 = 460;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    JRadioButton rbCP;
    JRadioButton rbCV;
    JRadioButton rbCT;
    JRadioButton rbP0;
    JRadioButton rbV0;
    JRadioButton rbT0;
    JRadioButton rbP1;
    JRadioButton rbV1;
    JRadioButton rbT1;
    JTextField tfP0;
    JTextField tfV0;
    JTextField tfT0;
    JTextField tfP1;
    JTextField tfV1;
    JTextField tfT1;
    JButton buReset;
    JButton buStart;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorButton2;
    Color colorWork;
    Color colorHeat;
    Color colorGas;
    Color colorCylinder;
    Color colorPiston;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String text14;
    String text15;
    String text16;
    String text17;
    String text18;
    String text19;
    String text20;
    String text21;
    String text22;
    String text23;
    String text24;
    final double cV = 2.5;
    final double cP = 3.5;
    final double factE = 0.02;
    final double tProc = 5.0;
    final double eps = 1.0E-6;
    int process;
    int size;
    double p0;
    double v0;
    double t0;
    double p1;
    double v1;
    double t1;
    double pp;
    double vv;
    double tt;
    double dw;
    double dq;
    int unitP;
    int unitV;
    int unitT;
    double[] polyWorkX;
    double[] polyWorkY;
    double[] polyHeatX;
    double[] polyHeatY;
    double[] polyCylX;
    double[] polyCylY;
    int xW;
    int yW;
    int xQ;
    int yQ;
    boolean on;
    double t;
    int range;
    boolean p0Changed;
    boolean v0Changed;
    boolean t0Changed;
    boolean p1Changed;
    boolean v1Changed;
    boolean t1Changed;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 440);
    }

    @Override
    protected void initAttributes() {
        this.polyWorkX = new double[7];
        this.polyWorkY = new double[7];
        this.polyHeatX = new double[7];
        this.polyHeatY = new double[7];
        this.polyCylX = new double[8];
        this.polyCylY = new double[8];
        this.setPolygonCylinder();
        this.process = 1;
        this.size = 6;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(Color.yellow, "colorButton2");
        this.colorWork = this.getColor(Color.blue, "colorWork");
        this.colorHeat = this.getColor(Color.red, "colorHeat");
        this.colorGas = this.getColor(Color.green, "colorGas");
        this.colorCylinder = this.getColor(Color.orange, "colorCylinder");
        this.colorPiston = this.getColor(Color.blue, "colorPiston");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.text14 = this.getText(t[15], "text14");
        this.text15 = this.getText(t[16], "text15");
        this.text16 = this.getText(t[17], "text16");
        this.text17 = this.getText(t[18], "text17");
        this.text18 = this.getText(t[19], "text18");
        this.text19 = this.getText(t[20], "text19");
        this.text20 = this.getText(t[21], "text20");
        this.text21 = this.getText(t[22], "text21");
        this.text22 = this.getText(t[23], "text22");
        this.text23 = this.getText(t[24], "text23");
        this.text24 = this.getText(t[25], "text24");
        this.coauthor = this.getText(t[26], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 460, 440);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(460, 0, 240, 440);
        ButtonGroup bg = new ButtonGroup();
        this.rbCP = this.pan.newRadioButton(this.text01, true, bg);
        this.rbCV = this.pan.newRadioButton(this.text02, false, bg);
        this.rbCT = this.pan.newRadioButton(this.text03, false, bg);
        this.pan.add(this.text04);
        bg = new ButtonGroup();
        this.rbP0 = new JRadioButton(this.text06 + ":", false);
        bg.add(this.rbP0);
        this.pan.add(this.rbP0, this.bgPanel, 0, 1, 10, 0);
        this.tfP0 = new JTextField();
        this.pan.add(this.tfP0, Color.white, 1, 1, 0, 0);
        JLabel lb = new JLabel(this.kilopascal);
        this.pan.add(lb, this.bgPanel, 2, 1, 5, 10);
        this.rbV0 = new JRadioButton(this.text07 + ":", false);
        bg.add(this.rbV0);
        this.pan.add(this.rbV0, this.bgPanel, 0, 1, 10, 0);
        this.tfV0 = new JTextField();
        this.pan.add(this.tfV0, Color.white, 1, 1, 0, 0);
        lb = new JLabel(this.decimeter3);
        this.pan.add(lb, this.bgPanel, 2, 1, 5, 10);
        this.rbT0 = new JRadioButton(this.text08 + ":", false);
        bg.add(this.rbT0);
        this.pan.add(this.rbT0, this.bgPanel, 0, 1, 10, 0);
        this.tfT0 = new JTextField();
        this.pan.add(this.tfT0, Color.white, 1, 1, 0, 0);
        lb = new JLabel(this.kelvin);
        this.pan.add(lb, this.bgPanel, 2, 1, 5, 10);
        this.pan.add(this.text05);
        bg = new ButtonGroup();
        this.rbP1 = new JRadioButton(this.text06 + ":", false);
        bg.add(this.rbP1);
        this.pan.add(this.rbP1, this.bgPanel, 0, 1, 10, 0);
        this.tfP1 = new JTextField();
        this.pan.add(this.tfP1, Color.white, 1, 1, 0, 0);
        lb = new JLabel(this.kilopascal);
        this.pan.add(lb, this.bgPanel, 2, 1, 5, 10);
        this.rbV1 = new JRadioButton(this.text07 + ":", false);
        bg.add(this.rbV1);
        this.pan.add(this.rbV1, this.bgPanel, 0, 1, 10, 0);
        this.tfV1 = new JTextField();
        this.pan.add(this.tfV1, Color.white, 1, 1, 0, 0);
        lb = new JLabel(this.decimeter3);
        this.pan.add(lb, this.bgPanel, 2, 1, 5, 10);
        this.rbT1 = new JRadioButton(this.text08 + ":", false);
        bg.add(this.rbT1);
        this.pan.add(this.rbT1, this.bgPanel, 0, 1, 10, 0);
        this.tfT1 = new JTextField();
        this.pan.add(this.tfT1, Color.white, 1, 1, 0, 0);
        lb = new JLabel(this.kelvin);
        this.pan.add(lb, this.bgPanel, 2, 1, 5, 10);
        this.buReset = this.pan.newButton(this.text09, this.colorButton1);
        this.buStart = this.pan.newButton(this.text10, this.colorButton2);
        this.pan.add(1999);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.tfP0.addActionListener(this);
        this.tfV0.addActionListener(this);
        this.tfT0.addActionListener(this);
        this.tfP1.addActionListener(this);
        this.tfV1.addActionListener(this);
        this.tfT1.addActionListener(this);
        this.tfP0.addCaretListener(this);
        this.tfV0.addCaretListener(this);
        this.tfT0.addCaretListener(this);
        this.tfP1.addCaretListener(this);
        this.tfV1.addCaretListener(this);
        this.tfT1.addCaretListener(this);
        this.setDefaultValues(this.process);
        this.setUnits();
        this.actionEnd();
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on) {
                this.t += (double)(t1 - t0) / 1000.0;
            }
            if (this.t >= 5.0) {
                this.on = false;
                this.t = 5.0;
            }
            t0 = t1;
        }
    }

    void setPolygonCylinder() {
        int x0 = 170;
        int y0 = 120;
        this.polyCylX[0] = 120.0;
        this.polyCylY[0] = 120.0;
        this.polyCylX[1] = 120.0;
        this.polyCylY[1] = 220.0;
        this.polyCylX[2] = 130.0;
        this.polyCylY[2] = 220.0;
        this.polyCylX[3] = 130.0;
        this.polyCylY[3] = 130.0;
        this.polyCylX[4] = 210.0;
        this.polyCylY[4] = 130.0;
        this.polyCylX[5] = 210.0;
        this.polyCylY[5] = 220.0;
        this.polyCylX[6] = 220.0;
        this.polyCylY[6] = 220.0;
        this.polyCylX[7] = 220.0;
        this.polyCylY[7] = 120.0;
    }

    void setPolygonWork() {
        double w;
        int x0 = 170;
        int y0 = 280;
        switch (this.process) {
            case 1: {
                this.dw = this.t0 - this.t1;
                break;
            }
            case 2: {
                this.dw = 0.0;
                break;
            }
            case 3: {
                this.dw = this.t0 * Math.log(this.p1 / this.p0);
            }
        }
        int sign = 1;
        if (this.dw < 0.0) {
            sign = -1;
            this.dw = -this.dw;
        }
        if ((w = this.dw * 0.02) == 0.0) {
            return;
        }
        if (w > 50.0) {
            w = 50.0;
        }
        this.polyWorkX[0] = 170.0;
        this.polyWorkY[0] = 280 - sign * 30;
        this.polyWorkX[1] = 170.0 - w - 20.0;
        this.polyWorkY[1] = 280 - sign * 10;
        this.polyWorkX[2] = 170.0 - w;
        this.polyWorkY[2] = 280 - sign * 10;
        this.polyWorkX[3] = 170.0 - w;
        this.polyWorkY[3] = 280 + sign * 30;
        this.polyWorkX[4] = 170.0 + w;
        this.polyWorkY[4] = 280 + sign * 30;
        this.polyWorkX[5] = 170.0 + w;
        this.polyWorkY[5] = 280 - sign * 10;
        this.polyWorkX[6] = 170.0 + w + 20.0;
        this.polyWorkY[6] = 280 - sign * 10;
        this.xW = 210;
        this.yW = 280;
    }

    void setPolygonHeat() {
        double q;
        switch (this.process) {
            case 1: {
                this.dq = 3.5 * (this.t1 - this.t0);
                break;
            }
            case 2: {
                this.dq = 2.5 * (this.t1 - this.t0);
                break;
            }
            case 3: {
                this.dq = this.t0 * Math.log(this.p0 / this.p1);
            }
        }
        int sign = 1;
        if (this.dq < 0.0) {
            sign = -1;
            this.dq = -this.dq;
        }
        if ((q = this.dq * 0.02) == 0.0) {
            return;
        }
        if (q > 50.0) {
            q = 50.0;
        }
        int x0 = 70;
        int y0 = 140;
        this.polyHeatX[0] = 70 + sign * 30;
        this.polyHeatY[0] = 140.0;
        this.polyHeatX[1] = 70 + sign * 10;
        this.polyHeatY[1] = 140.0 - q - 20.0;
        this.polyHeatX[2] = 70 + sign * 10;
        this.polyHeatY[2] = 140.0 - q;
        this.polyHeatX[3] = 70 - sign * 30;
        this.polyHeatY[3] = 140.0 - q;
        this.polyHeatX[4] = 70 - sign * 30;
        this.polyHeatY[4] = 140.0 + q;
        this.polyHeatX[5] = 70 + sign * 10;
        this.polyHeatY[5] = 140.0 + q;
        this.polyHeatX[6] = 70 + sign * 10;
        this.polyHeatY[6] = 140.0 + q + 20.0;
        this.xQ = Math.round(50.0f);
        this.yQ = (int)Math.round(140.0 + q + 40.0);
    }

    void reEnable() {
        this.tfP0.setEnabled(this.size != 1);
        this.tfP1.setEnabled(this.size != 4);
        this.tfV0.setEnabled(this.size != 2);
        this.tfV1.setEnabled(this.size != 5);
        this.tfT0.setEnabled(this.size != 3);
        this.tfT1.setEnabled(this.size != 6);
        this.rbCP.setEnabled(true);
        this.rbCV.setEnabled(true);
        this.rbCT.setEnabled(true);
        this.enableCBPVT(this.process);
        this.buReset.setEnabled(true);
        this.buStart.setEnabled(false);
    }

    void updateTF(JTextField tf) {
        if (tf == this.tfP0) {
            this.tfP0.setText(this.toString2(this.p0 / 1000.0, 3, 1.0E-6));
        } else if (tf == this.tfV0) {
            this.tfV0.setText(this.toString2(this.v0 * 1000.0, 3, 1.0E-6));
        } else if (tf == this.tfT0) {
            this.tfT0.setText(this.toString2(this.t0, 3, 1.0E-6));
        } else if (tf == this.tfP1) {
            this.tfP1.setText(this.toString2(this.p1 / 1000.0, 3, 1.0E-6));
        } else if (tf == this.tfV1) {
            this.tfV1.setText(this.toString2(this.v1 * 1000.0, 3, 1.0E-6));
        } else if (tf == this.tfT1) {
            this.tfT1.setText(this.toString2(this.t1, 3, 1.0E-6));
        }
    }

    void updateSize(int newSize) {
        this.enableTF(this.size, true);
        this.size = newSize;
        this.enableTF(this.size, false);
        JRadioButton rb = null;
        switch (this.size) {
            case 1: {
                rb = this.rbP0;
                break;
            }
            case 2: {
                rb = this.rbV0;
                break;
            }
            case 3: {
                rb = this.rbT0;
                break;
            }
            case 4: {
                rb = this.rbP1;
                break;
            }
            case 5: {
                rb = this.rbV1;
                break;
            }
            case 6: {
                rb = this.rbT1;
            }
        }
        if (rb != null) {
            rb.setSelected(true);
        }
    }

    void calcUnknown() {
        switch (this.size) {
            case 1: {
                this.p0 = this.p1 * this.v1 * this.t0 / (this.v0 * this.t1);
                this.updateTF(this.tfP0);
                break;
            }
            case 2: {
                this.v0 = this.p1 * this.v1 * this.t0 / (this.p0 * this.t1);
                this.updateTF(this.tfV0);
                break;
            }
            case 3: {
                this.t0 = this.p0 * this.v0 * this.t1 / (this.p1 * this.v1);
                this.updateTF(this.tfT0);
                break;
            }
            case 4: {
                this.p1 = this.p0 * this.v0 * this.t1 / (this.v1 * this.t0);
                this.updateTF(this.tfP1);
                break;
            }
            case 5: {
                this.v1 = this.p0 * this.v0 * this.t1 / (this.p1 * this.t0);
                this.updateTF(this.tfV1);
                break;
            }
            case 6: {
                this.t1 = this.p1 * this.v1 * this.t0 / (this.p0 * this.v0);
                this.updateTF(this.tfT1);
            }
        }
    }

    void input(JTextField tf) {
        if (tf == this.tfP0) {
            this.p0 = this.inputTF2(this.tfP0, 50.0, 500.0, 3, 1.0E-6) * 1000.0;
            if (this.process == 1) {
                this.p1 = this.p0;
                this.updateTF(this.tfP1);
            }
        } else if (tf == this.tfV0) {
            this.v0 = this.inputTF2(this.tfV0, 0.5, 5.0, 3, 1.0E-6) / 1000.0;
            if (this.process == 2) {
                this.v1 = this.v0;
                this.updateTF(this.tfV1);
            }
        } else if (tf == this.tfT0) {
            this.t0 = this.inputTF2(this.tfT0, 100.0, 1000.0, 3, 1.0E-6);
            if (this.process == 3) {
                this.t1 = this.t0;
                this.updateTF(this.tfT1);
            }
        } else if (tf == this.tfP1) {
            this.p1 = this.inputTF2(this.tfP1, 50.0, 500.0, 3, 1.0E-6) * 1000.0;
            if (this.process == 1) {
                this.p0 = this.p1;
                this.updateTF(this.tfP0);
            }
        } else if (tf == this.tfV1) {
            this.v1 = this.inputTF2(this.tfV1, 0.5, 5.0, 3, 1.0E-6) / 1000.0;
            if (this.process == 2) {
                this.v0 = this.v1;
                this.updateTF(this.tfV0);
            }
        } else if (tf == this.tfT1) {
            this.t1 = this.inputTF2(this.tfT1, 100.0, 1000.0, 3, 1.0E-6);
            if (this.process == 3) {
                this.t0 = this.t1;
                this.updateTF(this.tfT0);
            }
        }
        this.on = false;
        this.t = 0.0;
    }

    void inputAll() {
        if (this.p0Changed) {
            this.p0 = this.inputTF2(this.tfP0, 50.0, 500.0, 3, 1.0E-6) * 1000.0;
            if (this.process == 1) {
                this.p1 = this.p0;
                this.updateTF(this.tfP1);
            }
        }
        if (this.v0Changed) {
            this.v0 = this.inputTF2(this.tfV0, 0.5, 5.0, 3, 1.0E-6) / 1000.0;
            if (this.process == 2) {
                this.v1 = this.v0;
                this.updateTF(this.tfV1);
            }
        }
        if (this.t0Changed) {
            this.t0 = this.inputTF2(this.tfT0, 100.0, 1000.0, 3, 1.0E-6);
            if (this.process == 3) {
                this.t1 = this.t0;
                this.updateTF(this.tfT1);
            }
        }
        if (this.p1Changed) {
            this.p1 = this.inputTF2(this.tfP1, 50.0, 500.0, 3, 1.0E-6) * 1000.0;
            if (this.process == 1) {
                this.p0 = this.p1;
                this.updateTF(this.tfP0);
            }
        }
        if (this.v1Changed) {
            this.v1 = this.inputTF2(this.tfV1, 0.5, 5.0, 3, 1.0E-6) / 1000.0;
            if (this.process == 2) {
                this.v0 = this.v1;
                this.updateTF(this.tfV0);
            }
        }
        if (this.t1Changed) {
            this.t1 = this.inputTF2(this.tfT1, 100.0, 1000.0, 3, 1.0E-6);
            if (this.process == 3) {
                this.t0 = this.t1;
                this.updateTF(this.tfT0);
            }
        }
        this.calcUnknown();
    }

    void setUnits() {
        double max = this.p1 > this.p0 ? this.p1 : this.p0;
        this.unitP = (int)(5000000.0 / max);
        max = this.v1 > this.v0 ? this.v1 : this.v0;
        this.unitV = (int)(0.05 / max);
        max = this.t1 > this.t0 ? this.t1 : this.t0;
        this.unitT = (int)(5000.0 / max);
    }

    void setDefaultValues(int process) {
        switch (process) {
            case 1: {
                this.p1 = 100000.0;
                this.p0 = 100000.0;
                this.v0 = 0.001;
                this.v1 = 0.002;
                this.t0 = 300.0;
                this.t1 = 600.0;
                break;
            }
            case 2: {
                this.v1 = 0.001;
                this.v0 = 0.001;
                this.p0 = 100000.0;
                this.p1 = 200000.0;
                this.t0 = 300.0;
                this.t1 = 600.0;
                break;
            }
            case 3: {
                this.t1 = 300.0;
                this.t0 = 300.0;
                this.p0 = 100000.0;
                this.p1 = 200000.0;
                this.v0 = 0.002;
                this.v1 = 0.001;
            }
        }
        this.updateTF(this.tfP0);
        this.updateTF(this.tfP1);
        this.updateTF(this.tfV0);
        this.updateTF(this.tfV1);
        this.updateTF(this.tfT0);
        this.updateTF(this.tfT1);
    }

    void controllRange() {
        this.range = 0;
        switch (this.size) {
            case 1: {
                if (this.p0 < 50000.0) {
                    this.range = 1;
                    break;
                }
                if (!(this.p0 > 500000.0)) break;
                this.range = 2;
                break;
            }
            case 2: {
                if (this.v0 < 5.0E-4) {
                    this.range = 3;
                    break;
                }
                if (!(this.v0 > 0.005)) break;
                this.range = 4;
                break;
            }
            case 3: {
                if (this.t0 < 100.0) {
                    this.range = 5;
                    break;
                }
                if (!(this.t0 > 1000.0)) break;
                this.range = 6;
                break;
            }
            case 4: {
                if (this.p1 < 50000.0) {
                    this.range = 7;
                    break;
                }
                if (!(this.p1 > 500000.0)) break;
                this.range = 8;
                break;
            }
            case 5: {
                if (this.v1 < 5.0E-4) {
                    this.range = 9;
                    break;
                }
                if (!(this.v1 > 0.005)) break;
                this.range = 10;
                break;
            }
            case 6: {
                if (this.t1 < 100.0) {
                    this.range = 11;
                    break;
                }
                if (!(this.t1 > 1000.0)) break;
                this.range = 12;
            }
        }
    }

    void enableTF(int nr, boolean flag) {
        switch (nr) {
            case 1: {
                this.tfP0.setEnabled(flag);
                break;
            }
            case 2: {
                this.tfV0.setEnabled(flag);
                break;
            }
            case 3: {
                this.tfT0.setEnabled(flag);
                break;
            }
            case 4: {
                this.tfP1.setEnabled(flag);
                break;
            }
            case 5: {
                this.tfV1.setEnabled(flag);
                break;
            }
            case 6: {
                this.tfT1.setEnabled(flag);
            }
        }
    }

    void enableCBPVT(int process) {
        this.rbP0.setEnabled(false);
        this.rbP1.setEnabled(false);
        this.rbV0.setEnabled(false);
        this.rbV1.setEnabled(false);
        this.rbT0.setEnabled(false);
        this.rbT1.setEnabled(false);
        if (process == 0) {
            return;
        }
        boolean b = process == 2 || process == 3;
        this.rbP0.setEnabled(b);
        this.rbP1.setEnabled(b);
        b = process == 1 || process == 3;
        this.rbV0.setEnabled(b);
        this.rbV1.setEnabled(b);
        b = process == 1 || process == 2;
        this.rbT0.setEnabled(b);
        this.rbT1.setEnabled(b);
    }

    void actionEnd() {
        this.calcUnknown();
        this.controllRange();
        if (this.range == 0) {
            this.setUnits();
            this.setPolygonWork();
            this.setPolygonHeat();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o instanceof JTextField) {
            this.input((JTextField)o);
        } else if (o == this.rbCP) {
            this.process = 1;
            this.setDefaultValues(1);
            this.enableCBPVT(1);
            this.rbT1.setSelected(true);
        } else if (o == this.rbCV) {
            this.process = 2;
            this.setDefaultValues(2);
            this.enableCBPVT(2);
            this.rbT1.setSelected(true);
        } else if (o == this.rbCT) {
            this.process = 3;
            this.setDefaultValues(3);
            this.enableCBPVT(3);
            this.rbV1.setSelected(true);
        } else if (o instanceof JRadioButton) {
            if (this.rbP0.isSelected()) {
                this.updateSize(1);
            } else if (this.rbV0.isSelected()) {
                this.updateSize(2);
            } else if (this.rbT0.isSelected()) {
                this.updateSize(3);
            } else if (this.rbP1.isSelected()) {
                this.updateSize(4);
            } else if (this.rbV1.isSelected()) {
                this.updateSize(5);
            } else if (this.rbT1.isSelected()) {
                this.updateSize(6);
            }
        } else if (o == this.buReset) {
            this.inputAll();
            if (this.p1 != this.p0 || this.v1 != this.v0 || this.t1 != this.t0) {
                this.t = 0.0;
                this.on = false;
                this.buReset.setEnabled(false);
                this.buStart.setEnabled(true);
                for (int i = 1; i <= 6; ++i) {
                    this.enableTF(i, false);
                }
                this.rbCP.setEnabled(false);
                this.rbCV.setEnabled(false);
                this.rbCT.setEnabled(false);
                this.enableCBPVT(0);
                this.t0Changed = false;
                this.v0Changed = false;
                this.p0Changed = false;
                this.t1Changed = false;
                this.v1Changed = false;
                this.p1Changed = false;
            }
        } else if (o == this.buStart) {
            this.buReset.setEnabled(true);
            this.buStart.setEnabled(false);
            this.on = true;
        }
        this.actionEnd();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        JTextField tf = (JTextField)e.getSource();
        if (tf == this.tfP0) {
            this.p0Changed = true;
        } else if (tf == this.tfV0) {
            this.v0Changed = true;
        } else if (tf == this.tfT0) {
            this.t0Changed = true;
        } else if (tf == this.tfP1) {
            this.p1Changed = true;
        } else if (tf == this.tfV1) {
            this.v1Changed = true;
        } else if (tf == this.tfT1) {
            this.t1Changed = true;
        }
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, GasProcessesAP.this.bgCanvas);
            GasProcessesAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void cylinder(Graphics2D g) {
            int x0 = 170;
            int y0 = 120;
            double dy = GasProcessesAP.this.vv * 16000.0;
            CanvasAP.rectangle(g, 130.0, 130.0 + dy, 80.0, 10.0, GasProcessesAP.this.colorPiston);
            CanvasAP.rectangle(g, 165.0, 140.0 + dy, 10.0, 20.0, GasProcessesAP.this.colorPiston);
            g.setColor(Color.black);
            double y = 130.0 + dy;
            CanvasAP.line(g, 130.0, y, 210.0, y);
            CanvasAP.line(g, 130.0, y += 10.0, 165.0, y);
            CanvasAP.line(g, 175.0, y, 210.0, y);
            int x = 165;
            CanvasAP.line(g, x, y, x, y + 20.0);
            x = 175;
            CanvasAP.line(g, x, y, x, y + 20.0);
            CanvasAP.line(g, 165.0, y + 20.0, 175.0, y + 20.0);
            CanvasAP.rectangle(g, 130.0, 130.0, 80.0, dy, GasProcessesAP.this.colorGas);
            CanvasAP.polygon(g, GasProcessesAP.this.polyCylX, GasProcessesAP.this.polyCylY, GasProcessesAP.this.colorCylinder, true);
        }

        void manometer(Graphics2D g) {
            int x0 = 145;
            int y0 = 95;
            CanvasAP.circle(g, 145.0, 95.0, 25.0, Color.black);
            CanvasAP.circle(g, 145.0, 95.0, 20.0, Color.white);
            CanvasAP.rectangle(g, 143.0, 120.0, 4.0, 10.0, Color.black);
            for (int i = 0; i <= 5; ++i) {
                double phi = (1.25 - (double)i * 0.3) * Math.PI;
                double cos = Math.cos(phi);
                double sin = Math.sin(phi);
                double x1 = 145.0 + 15.0 * cos;
                double y1 = 95.0 - 15.0 * sin;
                double x2 = 145.0 + 20.0 * cos;
                double y2 = 95.0 - 20.0 * sin;
                CanvasAP.line(g, 2.0, x1, y1, x2, y2);
            }
            double phi = (1.25 - GasProcessesAP.this.pp * 0.3 / 100000.0) * Math.PI;
            double x1 = 145.0 + 11.0 * Math.cos(phi);
            double y1 = 95.0 - 11.0 * Math.sin(phi);
            CanvasAP.line(g, 2.0, 145.0, 95.0, x1, y1);
        }

        void thermometer(Graphics2D g) {
            int x0 = 200;
            int y0 = 95;
            double h1 = 20.0 + GasProcessesAP.this.tt * 0.06;
            CanvasAP.rectangle(g, 2.0, 180.0, 30.0, 40.0, 89.0, Color.white, true);
            g.setStroke(THIN);
            g.setColor(Color.white);
            g.fillRoundRect(198, 45, 4, 90, 5, 5);
            g.setColor(Color.gray);
            g.fillRoundRect(198, 115, 4, 20, 2, 2);
            CanvasAP.rectangle(g, 198.0, 135.0 - h1, 4.0, h1 - 10.0, Color.gray);
            g.setColor(Color.black);
            g.drawRoundRect(198, 45, 4, 90, 5, 5);
            for (int i = 1; i <= 10; ++i) {
                int y = 115 - i * 6;
                int h = i % 5 == 0 ? 15 : 10;
                CanvasAP.line(g, 200 - h, y, 197.0, y);
                CanvasAP.line(g, 203.0, y, 200 + h, y);
            }
        }

        void coordSystem(Graphics2D g, int u, int v, String s1, String s2, int unit1, int unit2) {
            int i;
            if (unit1 <= 0 || unit2 <= 0) {
                return;
            }
            g.setColor(Color.black);
            CanvasAP.arrow(g, u - 10, v, u + 100, v);
            for (i = u + unit1; i <= u + 80; i += unit1) {
                CanvasAP.line(g, i, v - 2, i, v + 2);
            }
            CanvasAP.arrow(g, u, v + 10, u, v - 100);
            for (i = v - unit2; i >= v - 80; i -= unit2) {
                CanvasAP.line(g, u - 2, i, u + 2, i);
            }
            CanvasAP.setAntiAliasing(g, false);
            g.drawString(s1, u + 92, v + 15);
            g.drawString(s2, u - 12, v - 90);
            CanvasAP.setAntiAliasing(g, true);
        }

        void diagramTV(Graphics2D g, int u, int v) {
            double pixT = 100.0;
            double pixV = 1000.0;
            this.coordSystem(g, u, v, "T", "V", GasProcessesAP.this.unitT, GasProcessesAP.this.unitV);
            double x0 = (double)u + GasProcessesAP.this.t0 * (double)GasProcessesAP.this.unitT / 100.0;
            double y0 = (double)v - GasProcessesAP.this.v0 * (double)GasProcessesAP.this.unitV * 1000.0;
            double x1 = (double)u + GasProcessesAP.this.t1 * (double)GasProcessesAP.this.unitT / 100.0;
            double y1 = (double)v - GasProcessesAP.this.v1 * (double)GasProcessesAP.this.unitV * 1000.0;
            CanvasAP.line(g, x0, y0, x1, y1);
            CanvasAP.circle(g, x0, y0, 2.0, Color.black);
            CanvasAP.circle(g, x1, y1, 2.0, Color.black);
            double xx = (double)u + GasProcessesAP.this.tt * (double)GasProcessesAP.this.unitT / 100.0;
            double yy = (double)v - GasProcessesAP.this.vv * (double)GasProcessesAP.this.unitV * 1000.0;
            CanvasAP.circle(g, xx, yy, 2.0, Color.magenta, true);
        }

        void diagramTP(Graphics2D g, int u, int v) {
            double pixT = 100.0;
            double pixP = 100000.0;
            this.coordSystem(g, u, v, "T", "p", GasProcessesAP.this.unitT, GasProcessesAP.this.unitP);
            double x0 = (double)u + GasProcessesAP.this.t0 * (double)GasProcessesAP.this.unitT / 100.0;
            double y0 = (double)v - GasProcessesAP.this.p0 * (double)GasProcessesAP.this.unitP / 100000.0;
            double x1 = (double)u + GasProcessesAP.this.t1 * (double)GasProcessesAP.this.unitT / 100.0;
            double y1 = (double)v - GasProcessesAP.this.p1 * (double)GasProcessesAP.this.unitP / 100000.0;
            CanvasAP.line(g, x0, y0, x1, y1);
            CanvasAP.circle(g, x0, y0, 2.0, Color.black);
            CanvasAP.circle(g, x1, y1, 2.0, Color.black);
            double xx = (double)u + GasProcessesAP.this.tt * (double)GasProcessesAP.this.unitT / 100.0;
            double yy = (double)v - GasProcessesAP.this.pp * (double)GasProcessesAP.this.unitP / 100000.0;
            CanvasAP.circle(g, xx, yy, 2.0, Color.magenta, true);
        }

        void diagramVP(Graphics2D g, int u, int v) {
            double x1;
            double pixV = 1000.0;
            double pixP = 100000.0;
            this.coordSystem(g, u, v, "V", "p", GasProcessesAP.this.unitV, GasProcessesAP.this.unitP);
            double x0 = (double)u + GasProcessesAP.this.v0 * (double)GasProcessesAP.this.unitV * 1000.0;
            double y0 = (double)v - GasProcessesAP.this.p0 * (double)GasProcessesAP.this.unitP / 100000.0;
            CanvasAP.circle(g, x0, y0, 2.0, Color.black);
            double xEnd = x1 = (double)u + GasProcessesAP.this.v1 * (double)GasProcessesAP.this.unitV * 1000.0;
            double y1 = (double)v - GasProcessesAP.this.p1 * (double)GasProcessesAP.this.unitP / 100000.0;
            CanvasAP.circle(g, x1, y1, 2.0, Color.black);
            if (GasProcessesAP.this.process <= 2) {
                CanvasAP.line(g, x0, y0, x1, y1);
            } else {
                int dir = GasProcessesAP.this.v1 > GasProcessesAP.this.v0 ? 1 : -1;
                x1 = x0 + (double)dir;
                while (dir > 0 && x1 <= xEnd || dir < 0 && x1 >= xEnd) {
                    double vDiagr = (x1 - (double)u) / ((double)GasProcessesAP.this.unitV * 1000.0);
                    y1 = (double)v - GasProcessesAP.this.p0 * GasProcessesAP.this.v0 / vDiagr * (double)GasProcessesAP.this.unitP / 100000.0;
                    CanvasAP.line(g, x0, y0, x1, y1);
                    x0 = x1;
                    y0 = y1;
                    x1 = x0 + (double)dir;
                }
            }
            double xx = (double)u + GasProcessesAP.this.vv * (double)GasProcessesAP.this.unitV * 1000.0;
            double yy = (double)v - GasProcessesAP.this.pp * (double)GasProcessesAP.this.unitP / 100000.0;
            CanvasAP.circle(g, xx, yy, 2.0, Color.magenta, true);
        }

        void messageRange(Graphics2D g) {
            String s1 = GasProcessesAP.this.range <= 6 ? GasProcessesAP.this.text04 : GasProcessesAP.this.text05;
            String s2 = "";
            switch (GasProcessesAP.this.range) {
                case 1: 
                case 7: {
                    s2 = GasProcessesAP.this.text19;
                    break;
                }
                case 2: 
                case 8: {
                    s2 = GasProcessesAP.this.text20;
                    break;
                }
                case 3: 
                case 9: {
                    s2 = GasProcessesAP.this.text21;
                    break;
                }
                case 4: 
                case 10: {
                    s2 = GasProcessesAP.this.text22;
                    break;
                }
                case 5: 
                case 11: {
                    s2 = GasProcessesAP.this.text23;
                    break;
                }
                case 6: 
                case 12: {
                    s2 = GasProcessesAP.this.text24;
                }
            }
            g.setColor(Color.red);
            g.drawString(s1, 150, 180);
            g.drawString(s2, 150, 200);
            GasProcessesAP.this.reEnable();
        }

        Color varColor(Color c, boolean light) {
            if (!light) {
                return c;
            }
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            r = (r + 255) / 2;
            g = (g + 255) / 2;
            b = (b + 255) / 2;
            return new Color(r, g, b);
        }

        void transportEnergy(Graphics2D g) {
            String txt2;
            String txt1;
            Color c;
            boolean on;
            boolean bl = on = GasProcessesAP.this.t > 0.0 && GasProcessesAP.this.t < 5.0;
            if (GasProcessesAP.this.dw != 0.0) {
                c = this.varColor(GasProcessesAP.this.colorWork, !on);
                CanvasAP.polygon(g, GasProcessesAP.this.polyWorkX, GasProcessesAP.this.polyWorkY, c, true);
            }
            if (GasProcessesAP.this.dq != 0.0) {
                c = this.varColor(GasProcessesAP.this.colorHeat, !on);
                CanvasAP.polygon(g, GasProcessesAP.this.polyHeatX, GasProcessesAP.this.polyHeatY, c, true);
            }
            CanvasAP.setAntiAliasing(g, false);
            if (GasProcessesAP.this.dw != 0.0) {
                g.setColor(GasProcessesAP.this.colorWork);
                g.drawString(GasProcessesAP.this.text11, GasProcessesAP.this.xW, GasProcessesAP.this.yW);
            }
            if (GasProcessesAP.this.dq != 0.0) {
                g.setColor(GasProcessesAP.this.colorHeat);
                g.drawString(GasProcessesAP.this.text12, GasProcessesAP.this.xQ, GasProcessesAP.this.yQ);
            }
            g.setColor(Color.black);
            if (GasProcessesAP.this.t1 > GasProcessesAP.this.t0) {
                txt1 = GasProcessesAP.this.text13;
                txt2 = GasProcessesAP.this.text14;
            } else if (GasProcessesAP.this.t1 == GasProcessesAP.this.t0) {
                txt1 = GasProcessesAP.this.text15;
                txt2 = GasProcessesAP.this.text16;
            } else {
                txt1 = GasProcessesAP.this.text17;
                txt2 = GasProcessesAP.this.text18;
            }
            g.drawString(txt1, 60, 370);
            g.drawString(txt2, 60, 385);
            CanvasAP.setAntiAliasing(g, true);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            g.setFont(this.fH);
            if (GasProcessesAP.this.t >= 5.0 && !GasProcessesAP.this.rbCP.isEnabled() && GasProcessesAP.this.range == 0) {
                GasProcessesAP.this.reEnable();
            }
            if (GasProcessesAP.this.range != 0) {
                this.messageRange(g2);
                return;
            }
            double part = GasProcessesAP.this.t / 5.0;
            if (GasProcessesAP.this.process <= 2) {
                GasProcessesAP.this.tt = GasProcessesAP.this.t0 + part * (GasProcessesAP.this.t1 - GasProcessesAP.this.t0);
                GasProcessesAP.this.pp = GasProcessesAP.this.p0 + part * (GasProcessesAP.this.p1 - GasProcessesAP.this.p0);
                GasProcessesAP.this.vv = GasProcessesAP.this.v0 + part * (GasProcessesAP.this.v1 - GasProcessesAP.this.v0);
            } else {
                GasProcessesAP.this.vv = GasProcessesAP.this.v0 * Math.exp(part * Math.log(GasProcessesAP.this.v1 / GasProcessesAP.this.v0));
                GasProcessesAP.this.pp = GasProcessesAP.this.p0 * GasProcessesAP.this.v0 / GasProcessesAP.this.vv;
                GasProcessesAP.this.tt = GasProcessesAP.this.t0;
            }
            CanvasAP.setAntiAliasing(g2, true);
            this.cylinder(g2);
            this.manometer(g2);
            this.thermometer(g2);
            this.transportEnergy(g2);
            this.diagramTV(g2, 310, 120);
            this.diagramTP(g2, 310, 260);
            this.diagramVP(g2, 310, 400);
        }
    }
}

